clear all
close all
fclose('all');
clc

tickx=0:45:360;
R=0;
font=16;
num=40;
x=0:9:360;

init=zeros(1,num+1);
RHES=init;
CTS=init;
RHET=init;
CTT=init;

for state=["S1" , "T2"]
    figure
    for txt=["Gas", "Hexane","ACN"]
        for j=1:num
            
            filename = sprintf("C:/Users/Gebruiker/Desktop/Internship/plots/SOC-Pyr-DMA-dihedral-data/SOC-Pyr-DMA-dihedral-data/%s/%s/angle(%d)/slurm.out",txt,"S1",j);
            fid=fopen(filename);
            C = textscan(fid, '%s');
            C=C{1};
            
            if state=="S1"
                %singlet
                in=1;
                Index = find(contains(C,'CT_AT'));
                CTS(j)=str2double(C{Index(in)+2});
                RHES(j)=str2double(C{Index(in)+5});
            elseif state=="T2"
                %Triplet
                in=2;
                Index = find(contains(C,'CT_AT'));
                CTT(j)=str2double(C{Index(5+in)+2});
                RHET(j)=str2double(C{Index(5+in)+5});
                fclose(fid);
            end
        end
        
        %periodic
        RHES(end)=RHES(1);
        CTS(end)=CTS(1);
        RHET(end)=RHET(1);
        CTT(end)=CTT(1);
        
        if R==1
            if  state=="S1"
                tit="$^1CT$";
                RCTplot_main(x,[],[],RHES,[],font,tit)
                mean(RHES(x>40 & x<300))
                 xlim([40 300])
                 xticks(tickx)
            else
                tit="$^3CT$";
                RCTplot_main(x,[],[],[],RHET,font,tit)
                xlim([40 300])
                xticks(tickx)
            end
            
        else
            
            if  state=="S1"
                tit="$^1CT$";
                RCTplot_main(x,100*CTS,[],[],[],font,tit)
                mean(100*CTS(x>40 & x<300))
                xlim([40 300])
                xticks(tickx)
            else
                tit="$^3CT$";
                RCTplot_main(x,[],100*CTT,[],[],font,tit)
                xlim([40 300])
                xticks(tickx)
            end
            
            hold on
            
        end
    end
    
    legend('$Gas$','$NHX$','$ACN$','Interpreter','latex')
    set(gca,'FontSize',font)
    
end







